const express = require('express');
const router = express.Router();
const db = require('../config/database');
const auth = require('../middleware/auth');

router.use(auth);

router.get('/stats', (req, res) => {
    try {
        const totalClientes = db.prepare('SELECT COUNT(*) as count FROM Clientes').get().count;
        const clientesActivos = db.prepare('SELECT COUNT(*) as count FROM Clientes WHERE Estado = ?').get('Activo').count;

        const saldos = db.prepare('SELECT SUM(SaldoTotal) as total, SUM(SaldoVencido) as vencido FROM CuentaRP').get();

        const ordenesAbiertas = db.prepare("SELECT COUNT(*) as count FROM OrdenesRP WHERE Estado != 'Completada' AND Estado != 'Cancelada'").get().count;
        const notasNoLeidas = db.prepare('SELECT COUNT(*) as count FROM NotasRP WHERE Leido = 0').get().count;

        res.json({
            totalClientes,
            clientesActivos,
            saldoTotalPendiente: saldos.total || 0,
            saldoVencido: saldos.vencido || 0,
            ordenesAbiertas,
            notasNoLeidas
        });
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
});

router.get('/alertas', (req, res) => {
    try {
        const alertas = [];

        // Mora 90+
        const morosos = db.prepare('SELECT c.ClienteID, c.Nombre FROM CuentaRP ct JOIN Clientes c ON ct.ClienteID = c.ClienteID WHERE ct.Aging_90Plus > 0').all();
        morosos.forEach(m => {
            alertas.push({
                tipo: 'mora',
                clienteId: m.ClienteID,
                mensaje: `Cliente ${m.Nombre} con saldo 90+ días vencido`
            });
        });

        // Notas no leidas (Priority) - limit to recent
        const notas = db.prepare("SELECT n.ClienteID, c.Nombre FROM NotasRP n JOIN Clientes c ON n.ClienteID = c.ClienteID WHERE n.Leido = 0 AND n.Tipo IN ('Cobranza', 'Importante')").all();
        notas.forEach(n => {
            alertas.push({
                tipo: 'nota',
                clienteId: n.ClienteID,
                mensaje: `Nota importante sin leer: ${n.Nombre}`
            });
        });

        res.json(alertas);
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
});

module.exports = router;
